﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.EFR.DAL
{
    public partial class WKF_CASEDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public WKF_CASEDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods
        
        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            Int32? objReturn = objSave.WKF_CASE_ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CASE_DUE_DATE, objSave.CASE_NUMBER, objSave.CASE_START_DATE, objSave.CREATEDBY, objSave.PARENT_CASE_ID, objSave.PATIENT_ID, objSave.REFERRAL_ID, objSave.STD_WKFCASETYPE_ID, objSave.UPDATEDBY, ref objReturn, objSave.STD_WKFCASESTS_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }
        
        #endregion
    }
}
